<?php

/**
 * This is the model class for table "AdminKlasy".
 *
 * The followings are the available columns in table 'AdminKlasy':
 * @property double $idAdmina
 * @property double $idKlasy
 */
class AdminKlasy extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return AdminKlasy the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'AdminKlasy';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(

			array('idAdmina, idKlasy', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idAdmina'=>Yii::t('AdminKlasy', 'idAdmina'),
			'idKlasy'=>Yii::t('AdminKlasy', 'idKlasy'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('idAdmina', $this->idAdmina);
		$criteria->compare('idKlasy', $this->idKlasy);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}